﻿
#region Using Directives
using System.ServiceModel;
using PUMA.ServiceContracts.ServiceInterface;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using PUMA.PcehrDataStore.Schemas;
#endregion

namespace PUMA.Client.Proxy
{
    /// <summary>
    /// 
    /// </summary>
    public class PatientMasterProxy : ClientBase<IPatientMasterService>, IPatientMasterService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public PatientMasterProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Gets the patient based on specified criteria.
        /// </summary>
        /// <param name="hospitalID">The hospital ID.</param>
        /// <param name="mrn">The MRN.</param>
        /// <param name="namespaceId">The namespace id.</param>
        /// <param name="currentLastName">Last name of the current.</param>
        /// <param name="currentFirstNames">The current first names.</param>
        /// <param name="dateOfBirth">The date of birth.</param>
        /// <param name="sexID">The sex ID.</param>
        /// <param name="medicareNumber">The medicare number.</param>
        /// <param name="medicareNumberSequence">The medicare number sequence.</param>
        /// <param name="dvaNumber">The dva number.</param>
        /// <param name="onlyCountryPatients">The only country patients.</param>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Get(int hospitalID, string mrn,int? namespaceId, string currentLastName, string currentFirstNames, DateTime? dateOfBirth, int? sexID, string medicareNumber, string medicareNumberSequence, string dvaNumber,bool? onlyCountryPatients, out PatientMaster item)
        {
            return Channel.Get(hospitalID, mrn, namespaceId, currentLastName, currentFirstNames, dateOfBirth, sexID, medicareNumber, medicareNumberSequence, dvaNumber,onlyCountryPatients, out item);
        }

        /// <summary>
        /// Gets all patient tile details based on the search parameters passed in.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="ward">The ward.</param>
        /// <param name="onlyShowPatientsNeededAManualIhiSearch">The only show patients needed A manual ihi search.</param>
        /// <param name="pcehrPatients">if set to <c>true</c> [pcehr patients].</param>
        /// <returns></returns>
        public ObservableCollection<PatientTile> GetAll(int? hospitalId, string ward, bool? onlyShowPatientsNeededAManualIhiSearch, bool pcehrPatients, bool withoutPcehrPatients)
        {
            return Channel.GetAll(hospitalId, ward, onlyShowPatientsNeededAManualIhiSearch, pcehrPatients, withoutPcehrPatients);
        }

        /// <summary>
        /// Gets all patients with a pcehr by hospital.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <returns></returns>
        public ObservableCollection<PatientTile> GetAllPcehrByHospital(int hospitalId)
        {
            return Channel.GetAllPcehrByHospital(hospitalId);
        }

        /// <summary>
        /// Gets all patients without a pcehr by hospital.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <returns></returns>
        public ObservableCollection<PatientTile> GetAllWithoutPcehrByHospital(int hospitalId)
        {
            return Channel.GetAllWithoutPcehrByHospital(hospitalId);
        }

        /// <summary>
        /// Gets the patient by id.
        /// </summary>
        /// <param name="patientMasterID">The patient master ID.</param>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool GetById(int patientMasterID, out PatientMaster item)
        {
            return Channel.GetById(patientMasterID, out item);
        }

        /// <summary>
        /// Gets the patient by MRN.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="mrn">The MRN.</param>
        /// <returns></returns>
        public ObservableCollection<PatientTile> GetByMrn(int hospitalId, string mrn)
        {
            return Channel.GetByMrn(hospitalId, mrn);
        }

        /// <summary>
        /// Saves the specified patient.
        /// </summary>
        /// <param name="patient">The patient.</param>
        /// <returns></returns>
        public bool Save(PatientMaster patient)
        {
            return Channel.Save(patient);
        }

        /// <summary>
        /// Deletes the specified patient.
        /// </summary>
        /// <param name="patient">The patient.</param>
        /// <returns></returns>
        public bool Delete(PatientMaster patient)
        {
            return Channel.Delete(patient);
        }
    }
}
