﻿
#region Using Directives
using System.ServiceModel;
using PUMA.ServiceContracts.ServiceInterface;
using PUMA.PcehrDataStore.Schemas;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.CommonSchemas;
#endregion

namespace PUMA.Client.Proxy
{
    /// <summary>
    /// 
    /// </summary>
    public class PatientProxy : ClientBase<IPatientService>, IPatientService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public PatientProxy(string endpointName)
            : base(endpointName)
        {
        }

        public List<PatientsMissingIhiReport> PatientsWithoutIhi(int? hospitalId)
        {
            return Channel.PatientsWithoutIhi(hospitalId);
        }

        public ObservableCollection<PatientTile> PatientsWithIhi(int? hospitalId)
        {
            return Channel.PatientsWithIhi(hospitalId);
        }

        public List<PatientsWithOverridesReport> PatientsWithOverridesReport(int? hospitalId)
        {
            return Channel.PatientsWithOverridesReport(hospitalId);
        }

        public bool Get(int patientID, bool includeFullDetails, out Patient patient, DateTime? lastUpdate = null)
        {
            return Channel.Get(patientID,includeFullDetails, out patient, lastUpdate);
        }


        public bool Update(Patient patient)
        {
            return Channel.Update(patient);
        }

        /// <summary>
        /// Records the disclosure.
        /// </summary>
        /// <param name="pcehrDisclosed">if set to <c>true</c> [pcehr disclosed].</param>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="user">The user.</param>
        /// <param name="auditInformation">The audit information.</param>
        /// <returns></returns>
        public bool RecordDisclosure(bool pcehrDisclosed, PatientIdentifierBase patientIdentifier, byte[] auditInformation)
        {
            return Channel.RecordDisclosure(pcehrDisclosed, patientIdentifier, auditInformation);
        }

        /// <summary>
        /// Gets the current disclosure reason.
        /// </summary>
        /// <param name="healthProviderOrganisationId">The health provider organisation id.</param>
        /// <param name="patientMasterId">The patient master id.</param>
        /// <returns></returns>
        public string GetCurrentDisclosureReason(int healthProviderOrganisationId, int patientMasterId)
        {
            return Channel.GetCurrentDisclosureReason(healthProviderOrganisationId, patientMasterId);
        }
    }
}
