﻿
#region Using Directives
using System.ServiceModel;
using PUMA.ServiceContracts.ServiceInterface;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.Generic;
#endregion

namespace PUMA.Client.Proxy
{
    /// <summary>
    /// 
    /// </summary>
    public class PcehrProxy : ClientBase<IPcehrService>, IPcehrService
    {
        /// <summary>
        /// Default constructor
        /// </summary>
        /// <param name="endpointName"></param>
        public PcehrProxy(string endpointName)
            : base(endpointName)
        {
        }

        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<ClinicalDocument> GetAll()
        {
            return Channel.GetAll();
        }

        /// <summary>
        /// Gets the specified episode ID.
        /// </summary>
        /// <param name="episodeID">The episode ID.</param>
        /// <param name="isPatientKnown">if set to <c>true</c> [is patient known].</param>
        /// <returns></returns>
        public ClinicalDocument Get(int episodeID, bool isPatientKnown)
        {
            return Channel.Get(episodeID, isPatientKnown);
        }

        /// <summary>
        /// Saves the specified pcehr.
        /// </summary>
        /// <param name="pcehr">The pcehr.</param>
        /// <returns></returns>
        public bool Save(ref ClinicalDocument clinicalDocument)
        {
            return Channel.Save(ref clinicalDocument);
        }

        /// <summary>
        /// Determines whether [is database available].
        /// </summary>
        /// <returns>
        ///   <c>true</c> if [is database available]; otherwise, <c>false</c>.
        /// </returns>
        public bool IsDatabaseAvailable()
        {
            return Channel.IsDatabaseAvailable();
        }

        /// <summary>
        /// Supersedes the specified pcehr.
        /// </summary>
        /// <param name="pcehr">The pcehr.</param>
        /// <returns></returns>
        public bool Supersede(ref ClinicalDocument clinicalDocument)
        {
            return Channel.Supersede(ref clinicalDocument);
        }
      
    }
}
