﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Reflection;

namespace PUMA.Helpers
{
    /// <summary>
    /// This clase holds all the helper methods for schemas
    /// </summary>
    static public class SchemaHelper
    {
        /// <summary>
        /// Updates the specified target item.
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="targetItem">The target item.</param>
        /// <param name="sourceItem">The source item.</param>
        public static void Update<T>(T targetItem, T sourceItem)
        {
            PropertyInfo[] fromFields = typeof(T).GetProperties();
            for (int count = 0; count < fromFields.Length; count++)
            {
                PropertyInfo fromField = (PropertyInfo)fromFields[count];
                if (fromField.CanWrite)
                {
                    object value = fromField.GetValue(sourceItem, null);
                    fromField.SetValue(targetItem, value, null);
                }
            }
        }
    }
}
