﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;
using System.ServiceModel.Channels;
using HIPS.CommonSchemas;
using PUMA.Operation;

namespace PUMA.Helpers
{
    /// <summary>
    /// Contains methods to assist with security.
    /// </summary>
    public static class SecurityHelper
    {
        /// <summary>
        /// Determines whether the specified permission has permission.
        /// </summary>
        /// <param name="permission">The permission to check.</param>
        /// <returns>
        ///   <c>true</c> if the user has the specified permission; otherwise, <c>false</c>.
        /// </returns>
        public static bool HasPermission(string permission)
        {
            return PumaOperationContext.Current.Permissions.Contains(permission);
        }

        /// <summary>
        /// Gets the user detail.
        /// </summary>
        /// <returns></returns>
        public static UserDetails GetUserDetail()
        {
            UserDetails user = new UserDetails();

            string[] login = ServiceSecurityContext.Current.PrimaryIdentity.Name.Split('\\');
            user.Login = login[1];
            user.Name = login[1];
            user.Domain = login[0];
            user.Role = UserRole.InteractiveUser;

            return user;
        }
    }

    //public enum FunctionalPermission
    //{
    //    SystemAccess = 1,
    //    SystemChangeHospital = 2,
    //    SystemChangeWard = 3,
    //    SystemSwitchUser = 4,
    //    MissingIHIAccess = 5,
    //    ViewAdvertisedPcehr = 6,
    //    ManageConsentAccess = 7,
    //    DisclosePcehrAccess = 8,
    //    RemoveDischargeAccess = 9,
    //    DischargeSummaryRead = 10,
    //    DischargeSummaryEdit = 11,
    //    DischargeSummaryFinalise = 10
    //}
}
