﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel;

namespace PUMA.Operation
{
    /// <summary>
    /// Provides access to PUMA user specific information throught the App Server.
    /// </summary>
    public class PumaOperationContext : IExtension<OperationContext>
    {
        #region Properties

        /// <summary>
        /// Prevents a default instance of the <see cref="PumaOperationContext"/> class from being created.
        /// </summary>
        private PumaOperationContext()
        {
        }

        /// <summary>
        /// Gets or sets the hospital id.
        /// </summary>
        /// <value>
        /// The hospital id.
        /// </value>
        public Int32 HospitalId { get; set; }

        /// <summary>
        /// Gets or sets the IP address.
        /// </summary>
        /// <value>
        /// The IP address.
        /// </value>
        public string IPAddress { get; set; }

        /// <summary>
        /// Gets or sets the name of the machine.
        /// </summary>
        /// <value>
        /// The name of the machine.
        /// </value>
        public string MachineName { get; set; }

        /// <summary>
        /// Gets or sets the permissions.
        /// </summary>
        /// <value>
        /// The permissions.
        /// </value>
        public List<string> Permissions { get; set; }

        /// <summary>
        /// Gets the current.
        /// </summary>
        /// <value>
        /// The current.
        /// </value>
        public static PumaOperationContext Current
        {
            get
            {
                PumaOperationContext context = OperationContext.Current.Extensions.Find<PumaOperationContext>();
                if (context == null)
                {
                    context = new PumaOperationContext();
                    OperationContext.Current.Extensions.Add(context);
                }
                return context;
            }
        }

        #endregion

        #region Methods

        /// <summary>
        /// Attaches the specified owner.
        /// </summary>
        /// <param name="owner">The owner.</param>
        public void Attach(OperationContext owner) { }

        /// <summary>
        /// Detaches the specified owner.
        /// </summary>
        /// <param name="owner">The owner.</param>
        public void Detach(OperationContext owner) { }

        #endregion
    }
}
