﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PUMA.PcehrDataStore.Schemas;
using System.Data.SqlClient;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Audit table
    /// </summary>
    public class AuditDl : BaseDl
    {
        #region Methods
        /// <summary>
        /// Inserts the specified audit.
        /// </summary>
        /// <param name="Audit">The audit.</param>
        /// <returns></returns>
         public bool Insert(Audit audit)
        {
            using (SqlCommand command = GetSqlCommand("dbo.AuditInsert"))
            {
                return base.Insert<Audit>(audit, command);
            }
        }
         /// <summary>
         /// Inserts the specified MRN.
         /// </summary>
         /// <param name="mrn">The MRN.</param>
         /// <param name="medicareNumber">The medicare number.</param>
         /// <param name="medicareNumberSequence">The medicare number sequence.</param>
         /// <param name="name">The name.</param>
         /// <param name="deviceId">The device id.</param>
         /// <param name="userId">The user id.</param>
         /// <param name="episoideId">The episoide id.</param>
         /// <returns></returns>
         public bool Insert(string mrn, string medicareNumber, string medicareNumberSequence, string name, string deviceId, string userId,  int? episoideId)
         {
             Audit audit = new Audit();
             audit.UserAccount = userId;
             audit.Mrn = mrn;
             audit.MedicareNumber = medicareNumber;
             audit.MedicareNumberSeq = medicareNumberSequence;
             audit.PatientName = name;
             audit.EpisodeID = episoideId;
             audit.DeviceID = deviceId;
             return Insert(audit);
         }
        #endregion
    }
}
