﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PUMA.PcehrDataStore.Schemas;
using System.Data.SqlClient;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using PUMA.Helpers;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Complication table
    /// </summary>
    public class ComplicationDl : BaseDl
    {
        #region Methods
        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Complication> GetAll()
        {
            List<Complication> results = new List<Complication>();
            try
            {
                using (SqlCommand command = GetSqlCommand("dbo.ComplicationList"))
                {
                    results = GetPopulatedBusinessList<Complication>(command.ExecuteReader());
                    
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageComplicationGet, ex, SecurityHelper.GetUserDetail(), LogMessage.PUMA_MESSAGE_1001);
            }
            return results;
        }

        public bool Insert(Complication complication)
        {
            using (SqlCommand command = GetSqlCommand("dbo.ComplicationInsert"))
            {
                return base.Insert<Complication>(complication, command);
            }
        }

        public bool Update(Complication complication)
        {
            using (SqlCommand command = GetSqlCommand("dbo.ComplicationUpdate"))
            {
                return base.Update<Complication>(complication, command);
            }
        }

        public bool Delete(Complication complication)
        {
            using (SqlCommand command = GetSqlCommand("dbo.ComplicationDelete"))
            {
                return base.Delete<Complication>(complication, command);
            }
        }
        #endregion
    }
}
