﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using PUMA.Helpers;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// Provides access to the ConsentAudit table
    /// </summary>
    public class ConsentAuditDl : BaseDl
    {
        /// <summary>
        /// Gets the current response.
        /// </summary>
        /// <param name="episodeId">The episode id.</param>
        /// <returns></returns>
        public ConsentAudit GetCurrentConsentAudit(int episodeId)
        {
            ConsentAudit consentAudit = new ConsentAudit();
            bool result;

            try
            {
                using (SqlCommand command = GetSqlCommand(StoredProceduresResource.ConsentAuditCurrentGet))
                {
                    AddIntParameter(ParametersResource.EpisodeId, episodeId, command);
                    result = PopulateBusinessObject<ConsentAudit>(command.ExecuteReader(), consentAudit);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageConsentAudit, ex, SecurityHelper.GetUserDetail(), LogMessage.PUMA_MESSAGE_1002);
            }
            
            return consentAudit;
        }
    }
}
