﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using HIPS.CommonSchemas;
using PUMA.Helpers;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Diagnosis table
    /// </summary>
    public class DiagnosisDl : BaseDl
    {

        #region Methods
        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Diagnosis> GetAll()
        {
            return GetAll(null);
        }
        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Diagnosis> GetAll(DateTime? lastUpdated)
        {
            List<Diagnosis> results = new List<Diagnosis>();
            try
            {
                using (SqlCommand command = GetSqlCommand("dbo.DiagnosisList"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated));
                    }
                    results = GetPopulatedBusinessList<Diagnosis>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageDiagnosisGet, ex, SecurityHelper.GetUserDetail(), LogMessage.PUMA_MESSAGE_1003);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified Diagnosis id.
        /// </summary>
        /// <param name="DiagnosisId">The Diagnosis id.</param>
        /// <returns></returns>
        public Diagnosis Get(int DiagnosisId)
        {
            Diagnosis result = new Diagnosis();
            try
            {
                using (SqlCommand command = GetSqlCommand("dbo.DiagnosisGet"))
                {
                    command.Parameters.Add(new SqlParameter("@DiagnosisID", DiagnosisId));
                    PopulateBusinessObject<Diagnosis>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageDiagnosisGet, ex, new UserDetails(), LogMessage.PUMA_MESSAGE_1004);
            }
            return result;
        }

        #endregion
    }
}
