﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using PUMA.Helpers;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// Provides access to the DisclosureAudit table
    /// </summary>
    public class DisclosureAuditDl : BaseDl
    {
        /// <summary>
        /// Gets the current disclosure audit.
        /// </summary>
        /// <param name="healthProviderOrganisationId">The health provider organisation id.</param>
        /// <param name="patientMasterId">The patient master id.</param>
        /// <returns></returns>
        public DisclosureAudit GetCurrentDisclosureAudit(int healthProviderOrganisationId, int patientMasterId)
        {
            DisclosureAudit disclosureAudit = new DisclosureAudit();
            bool result;

            try
            {
                using (SqlCommand command = GetSqlCommand(StoredProceduresResource.DisclosureAuditCurrentGet))
                {
                    AddIntParameter(ParametersResource.HealthProviderOrganisationId, healthProviderOrganisationId, command);
                    AddIntParameter(ParametersResource.PatientMasterId, patientMasterId, command);
                    result = PopulateBusinessObject<DisclosureAudit>(command.ExecuteReader(), disclosureAudit);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageDisclosureAudit, ex, SecurityHelper.GetUserDetail(), LogMessage.PUMA_MESSAGE_1005);
            }
            
            return disclosureAudit;
        }
    }
}
