﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;
using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.ObjectModel;
using PUMA.Helpers;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the episode IHI Check List table
    /// </summary>
    public class EpisodeIhiCheckListDl : BaseDl
    {
        #region Methods



        /// <summary>
        /// Gets all the check list items for this patient and episode.
        /// </summary>
        /// <param name="episodeId">The episode IDL.</param>
        /// <param name="patientId">The patient id.</param>
        /// <returns></returns>
        public ObservableCollection<EpisodeIhiCheckList> GetAll(int episodeId)
        {
            ObservableCollection<EpisodeIhiCheckList> results = new ObservableCollection<EpisodeIhiCheckList>();
            try
            {
                using (SqlCommand command = GetSqlCommand(StoredProceduresResource.EpisodeIhiCheckListGet))
                {
                    AddIntParameter(ParametersResource.EpisodeId, episodeId, command);
                    results = GetPopulatedBusinessObservableCollection<EpisodeIhiCheckList>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog("Error getting the list of EpisodeIcdProcedure", ex, SecurityHelper.GetUserDetail(), LogMessage.PUMA_MESSAGE_1012);
            }
            return results;
        }

        /// <summary>
        /// Updates the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Update(EpisodeIhiCheckList item)
        {
            using (SqlCommand command = GetSqlCommand(StoredProceduresResource.EpisodeIhiCheckListUpdate))
            {
                return base.Update<EpisodeIhiCheckList>(item, command);
            }
        }

        #endregion
     }
}
