﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Common.PcehrDataStore.DataAccess;
using System.Collections.ObjectModel;
using PUMA.PcehrDataStore.Schemas;
using System.Data.SqlClient;
using HIPS.Common.DataStore.DataAccess;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    public class HelpPageDl : BaseDl
    {
        #region Constructor
        public HelpPageDl(HIPS.CommonSchemas.UserDetails userDetails)
            : base(userDetails)
        {
        }
        #endregion

        #region Methods

        /// <summary>
        /// Lists this instance.
        /// </summary>
        /// <returns></returns>
        public ObservableCollection<HelpPageDetail> List()
        {
            ObservableCollection<HelpPageDetail> results = new ObservableCollection<HelpPageDetail>();
            try
            {
                using (SqlCommand command = GetSqlCommand(StoredProceduresResource.HelpPageList))
                {
                    results = GetPopulatedBusinessObservableCollection<HelpPageDetail>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageHelpPageDetailList, ex, User, LogMessage.PUMA_MESSAGE_1013);
            }
            return results;
        }

        #endregion
    }
}
