﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using System.Collections.ObjectModel;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Hosptal view
    /// </summary>
    public class HospitalDl : HIPS.PcehrDataStore.DataAccess.HospitalDl
    {
        #region Constructor
        public HospitalDl()
            : base()
        {
        }
        #endregion

        #region Methods
        /// <summary>
        /// Gets all the wards with the selected Hospital or all hospitals if the id is null.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <returns></returns>
        public List<Hospital> GetActive()
        {
            List<Hospital> results = new List<Hospital>();
            try
            {
                using (SqlCommand command = GetSqlCommand(StoredProceduresResource.HospitalPumaActiveGet))
                {
                    results = GetPopulatedBusinessList<Hospital>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageHospitalGet, ex, User, LogMessage.PUMA_MESSAGE_1014);
            }
            return results;
        }
        #endregion
    }
}
