﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using System.Collections.ObjectModel;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Hosptal Ward view
    /// </summary>
    public class HospitalWardDl : BaseDl
    {
        #region Constructor
        public HospitalWardDl()
            : base()
        {
        }
        #endregion

        #region Methods
        /// <summary>
        /// Gets all the wards with the selected Hospital or all hospitals if the id is null.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <returns></returns>
        public ObservableCollection<HospitalWard> GetAll(int? hospitalId)
        {
            ObservableCollection<HospitalWard> results = new ObservableCollection<HospitalWard>();
            try
            {
                using (SqlCommand command = GetSqlCommand(StoredProceduresResource.HospitalWardGet))
                {
                    AddIntParameter(ParametersResource.HospitalId, hospitalId, command);
                    results = GetPopulatedBusinessObservableCollection<HospitalWard>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageMenuGet, ex, new UserDetails(), LogMessage.PUMA_MESSAGE_1015);
            }
            return results;
        }
        #endregion
    }
}
