﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using PUMA.Operation;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using System.Collections.ObjectModel;
using System.Data;
using PUMA.Helpers;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Menu table
    /// </summary>
    public class MenuDl : BaseDl
    {
        #region Methods

        /// <summary>
        /// Gets all the menu items.
        /// </summary>
        /// <returns></returns>
        public ObservableCollection<Menu> GetAll()
        {
            ObservableCollection<Menu> results = new ObservableCollection<Menu>();
            try
            {
                using (SqlCommand command = GetSqlCommand("[puma].MenuGet"))
                {
                    DataTable permissions = new DataTable();
                    permissions.Columns.Add(new DataColumn("FunctionalPermissionName", typeof(string)));
                    foreach (string functionalPermissionName in PumaOperationContext.Current.Permissions)
                    {
                        permissions.Rows.Add(functionalPermissionName);
                    }

                    SqlParameter parameter;
                    parameter = command.Parameters.AddWithValue(ParametersResource.FunctionalPermissions, permissions);
                    parameter.SqlDbType = SqlDbType.Structured;
                    parameter.TypeName = "puma.FunctionalPermissionTVP";
                    
                    results = GetPopulatedBusinessObservableCollection<Menu>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageMenuGet, ex, SecurityHelper.GetUserDetail(), LogMessage.PUMA_MESSAGE_1016);
            }

            return results;
        }
        #endregion
    }
}
