﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using PUMA.PcehrDataStore.Schemas;
using System.Configuration;
using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using System.Transactions;
using HIPS.PcehrDataStore.Schemas.Schemas;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the patient master table
    /// </summary>
    public class PatientMasterDl : HIPS.PcehrDataStore.DataAccess.PatientMasterDl
    {
        public PatientMasterDl(UserDetails user) : base(user) { }
        #region Methods
        /// <summary>
        /// Gets the specified patient master record by ID.
        /// </summary>
        /// <param name="patientMasterId">The patient master ID.</param>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Get(int patientMasterId, out PatientMaster item)
        {
            PatientMaster pumaItem = new PatientMaster();
            item = pumaItem;
            bool result = false;
            try
            {
                using (SqlCommand command = GetSqlCommand(StoredProceduresResource.PatientMasterGet))
                {
                    AddIntParameter(ParametersResource.PatientMasterId, patientMasterId, command);
                    result = PopulateBusinessObject<PatientMaster>(command.ExecuteReader(), pumaItem);
                    if (item.PatientMasterId.HasValue)
                    {
                        AddressDl addressDl = new AddressDl();
                        item.Addresses = addressDl.GetAllByPatient(item.PatientMasterId.Value);
                        ContactDl contactDl = new ContactDl();
                        item.Contacts = contactDl.GetAllByPatient(item.PatientMasterId.Value);
                        PatientMasterNameDl nameDl = new PatientMasterNameDl();
                        item.Names = nameDl.GetAllByPatient(item.PatientMasterId.Value);
                        
                    }
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                string message = string.Format(ConstantsResource.ErrorMessagePatientMasterGetById, patientMasterId);
                EventLogger.WriteLog(message, ex, User, LogMessage.PUMA_MESSAGE_1021);
            }
            return result;
        }

        /// <summary>
        /// Inserts the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Insert(PatientMaster item)
        {
            bool updated = false;
            SqlTransaction transaction = null;

            using (SqlCommand command = GetSqlCommand("puma.PatientMasterInsert"))
            {
                try
                {
                    transaction = command.Connection.BeginTransaction();
                    command.Transaction = transaction;

                    updated = base.Insert<PatientMaster>(item, command);
                    if (updated)
                    {
                        updated = UpdateName(item, command.Connection, transaction);
                    }
                    if (updated)
                    {
                        updated = UpdateAddress(item, command.Connection, transaction);
                    }
                    if (updated)
                    {
                        updated = UpdateContact(item, command.Connection, transaction);
                    }
                    if (updated)
                    {
                        transaction.Commit();
                    }
                    else
                    {
                        transaction.Rollback();
                    }
                }
                catch (Exception ex)
                {
                    if (transaction != null)
                    {
                        transaction.Rollback();
                    }
                    command.Connection.Close();
                    EventLogger.WriteLog(ConstantsResource.ErrorPatientMasterInsert, ex, new UserDetails(), LogMessage.PUMA_MESSAGE_1022);
                }
            }

            return updated;
        }

        /// <summary>
        /// Updates the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Update(PatientMaster item)
        {
            bool updated = false;
            SqlTransaction transaction = null;

            using (SqlCommand command = GetSqlCommand("puma.PatientMasterUpdate"))
            {
                try
                {
                    transaction = command.Connection.BeginTransaction();
                    command.Transaction = transaction;

                    updated = base.Update<PatientMaster>(item, command);
                    if (updated)
                    {
                        updated = UpdateName(item, command.Connection, transaction);
                    }

                    if (updated)
                    {
                        updated = UpdateAddress(item, command.Connection, transaction);
                    }
                    if (updated)
                    {
                        updated = UpdateContact(item, command.Connection, transaction);
                    }
                    if (updated)
                    {
                        transaction.Commit();
                        command.Connection.Close();
                    }
                    else
                    {
                        transaction.Rollback();
                        command.Connection.Close();
                    }
                }
                catch (Exception ex)
                {
                    if (transaction != null)
                    {
                        transaction.Rollback();
                    }
                    command.Connection.Close();
                    string message = string.Format(ConstantsResource.ErrorPatientMasterUpdate, item.PatientMasterId);
                    EventLogger.WriteLog(message, ex, new UserDetails(), LogMessage.PUMA_MESSAGE_1023);
                }
            }

            return updated;
        }

        /// <summary>
        /// Deletes the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Delete(PatientMaster item)
        {
            using (SqlCommand command = GetSqlCommand("puma.PatientMasterDelete"))
            {
                return base.Delete<PatientMaster>(item, command);
            }
        }

        #region Childen Methods

        /// <summary>
        /// Updates the name records.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        private bool UpdateAddress(PatientMaster item, SqlConnection connection , SqlTransaction transaction)
        {
            AddressDl addressDl = new AddressDl();
            return addressDl.Update(item.Addresses, item.PatientMasterId.Value, transaction);
        }
        /// <summary>
        /// Updates the contact.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        private bool UpdateContact(PatientMaster item, SqlConnection connection, SqlTransaction transaction = null)
        {
            ContactDl contactDl = new ContactDl();
            return contactDl.Update(item.Contacts, item.PatientMasterId.Value, transaction);
        }
        /// <summary>
        /// Updates the name.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <param name="connection">The connection.</param>
        /// <param name="transaction">The transaction.</param>
        /// <returns></returns>
        private bool UpdateName(PatientMaster item, SqlConnection connection, SqlTransaction transaction)
        {
            PatientMasterNameDl nameDl = new PatientMasterNameDl();
            return nameDl.Update(item.Names, item.PatientMasterId.Value, transaction);
        }

        #endregion

        #endregion
    }
}
