﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Configuration;
using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.ObjectModel;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class performs all data access on the Patient Master Override Table
    /// </summary>
    public class PatientMasterOverrideDl : BaseDl
    {
        #region Methods


        /// <summary>
        /// Updates the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Save(PatientMasterOverride item)
        {
            using (SqlCommand command = GetSqlCommand(StoredProceduresResource.PatientMasterOverrideSave))
            {
                return base.Update<PatientMasterOverride>(item, command);
            }
        }

        /// <summary>
        /// Deletes the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        public bool Delete(PatientMasterOverride item)
        {
            using (SqlCommand command = GetSqlCommand(StoredProceduresResource.PatientMasterOverrideDelete))
            {
                return base.Delete<PatientMasterOverride>(item, command);
            }
        }

        #endregion
     }
}
