﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using System.Collections.ObjectModel;
using PUMA.Helpers;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the Patient Tile View
    /// </summary>
    
    public class PatientTileDl : BaseDl
    {

        #region Methods

        public ObservableCollection<PatientTile> GetAll(int? hospitalId, string ward, bool? onlyShowPatientsNeededAManualIhiSearch, DateTime? dischargeDate, bool pcehrPatients, bool withoutPcehrPatients)
        {
            ObservableCollection<PatientTile> results = new ObservableCollection<PatientTile>();
            try
            {
                using (SqlCommand command = GetSqlCommand(StoredProceduresResource.PatientTileGet))
                {
                    AddIntParameter(ParametersResource.HospitalId, hospitalId, command);
                    AddStringParameter(ParametersResource.Ward, ward, command);
                    AddBoolParameter(ParametersResource.OnlyUserToSearchForIhi, onlyShowPatientsNeededAManualIhiSearch, command);
                    AddDateParameter(ParametersResource.DischargeDate, dischargeDate, command);
                    AddBoolParameter(ParametersResource.PcehrPatients, pcehrPatients, command);
                    AddBoolParameter(ParametersResource.WithoutPcehrPatients, withoutPcehrPatients, command);
                    results = GetPopulatedBusinessObservableCollection<PatientTile>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorPatientTileGet, ex, SecurityHelper.GetUserDetail(), LogMessage.PUMA_MESSAGE_1024);
            }
            return results;
        }

        /// <summary>
        /// Gets the patient by their MRN.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="mrn">The MRN.</param>
        /// <returns></returns>
        public ObservableCollection<PatientTile> GetByMrn(int hospitalId, string mrn)
        {
            ObservableCollection<PatientTile> results = new ObservableCollection<PatientTile>();
            try
            {
                using (SqlCommand command = GetSqlCommand(StoredProceduresResource.PatientTileMrnGet))
                {
                    AddIntParameter(ParametersResource.HospitalId, hospitalId, command);
                    AddStringParameter(ParametersResource.Mrn, mrn, command);
                    results = GetPopulatedBusinessObservableCollection<PatientTile>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessagePatientTileMrnGet, ex, SecurityHelper.GetUserDetail(), LogMessage.PUMA_MESSAGE_1025);
            }
            return results;
        }

        #endregion
    }
}
