﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using PUMA.Helpers;
using HIPS.PcehrDataStore.Schemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// Provides access to the RemoveAudit table
    /// </summary>
    public class RemoveAuditDl : BaseDl
    {

        /// <summary>
        /// Gets the current remove audit.
        /// </summary>
        /// <param name="clinicalDocumentId">The clinical document id.</param>
        /// <returns></returns>
        public RemoveAudit GetCurrentRemoveAudit(int clinicalDocumentId)
        {
            RemoveAudit removeAudit = new RemoveAudit();
            bool result;

            try
            {
                using (SqlCommand command = GetSqlCommand(StoredProceduresResource.RemoveAuditGet))
                {
                    AddIntParameter(ParametersResource.ClinicalDocumentId, clinicalDocumentId, command);
                    result = PopulateBusinessObject<RemoveAudit>(command.ExecuteReader(), removeAudit);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageRemoveAudit, ex, SecurityHelper.GetUserDetail(), LogMessage.PUMA_MESSAGE_1026);
            }

            return removeAudit;
        }
    }
}
