﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using HIPS.CommonSchemas;
using PUMA.Helpers;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the SeparationLocation table
    /// </summary>
    public class SeparationLocationDl : BaseDl
    {

        #region Methods
        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<SeparationLocation> GetAll()
        {
            return GetAll(null);
        }
        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<SeparationLocation> GetAll(DateTime? lastUpdated)
        {
            List<SeparationLocation> results = new List<SeparationLocation>();
            try
            {
                using (SqlCommand command = GetSqlCommand("dbo.SeparationLocationList"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated));
                    }
                    results = GetPopulatedBusinessList<SeparationLocation>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageSeparationLocationGet, ex, SecurityHelper.GetUserDetail(), LogMessage.PUMA_MESSAGE_1031);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified SeparationLocation id.
        /// </summary>
        /// <param name="SeparationLocationId">The SeparationLocation id.</param>
        /// <returns></returns>
        public SeparationLocation Get(int SeparationLocationId)
        {
            SeparationLocation result = new SeparationLocation();
            try
            {
                using (SqlCommand command = GetSqlCommand("dbo.SeparationLocationGet"))
                {
                    command.Parameters.Add(new SqlParameter("@SeparationLocationID", SeparationLocationId));
                    PopulateBusinessObject<SeparationLocation>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageSeparationLocationGet, ex, new UserDetails(), LogMessage.PUMA_MESSAGE_1032);
            }
            return result;
        }


        #endregion
    }
}
