﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using PUMA.PcehrDataStore.Schemas;
using PUMA.PcehrDataStore.DataAccess;
using HIPS.PcehrDataStore.DataAccess;
using HIPS.Common.PcehrDataStore.DataAccess;
using HIPS.Common.DataStore.DataAccess;
using HIPS.CommonSchemas;
using PUMA.Helpers;
using HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.DataAccess
{
    /// <summary>
    /// This class allows access to the SpecialityDescription table
    /// </summary>
    public class SpecialityDl : BaseDl
    {

        #region Methods
        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Speciality> GetAll()
        {
            return GetAll(null);
        }
        /// <summary>
        /// Gets all.
        /// </summary>
        /// <returns></returns>
        public List<Speciality> GetAll(DateTime? lastUpdated)
        {
            List<Speciality> results = new List<Speciality>();
            try
            {
                using (SqlCommand command = GetSqlCommand("dbo.SpecialityList"))
                {
                    if (lastUpdated.HasValue)
                    {
                        command.Parameters.Add(new SqlParameter("@DateModified", lastUpdated));
                    }
                    results = GetPopulatedBusinessList<Speciality>(command.ExecuteReader());
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageSpecialityDescriptionGet, ex, SecurityHelper.GetUserDetail(), LogMessage.PUMA_MESSAGE_1033);
            }
            return results;
        }

        /// <summary>
        /// Gets the specified Speciality Description id.
        /// </summary>
        /// <param name="SpecialityId">The Speciality Description id.</param>
        /// <returns></returns>
        public Speciality Get(int SpecialityId)
        {
            Speciality result = new Speciality();
            try
            {
                using (SqlCommand command = GetSqlCommand("dbo.SpecialityGet"))
                {
                    command.Parameters.Add(new SqlParameter("@SpecialityID", SpecialityId));
                    PopulateBusinessObject<Speciality>(command.ExecuteReader(), result);
                    command.Connection.Close();
                }
            }
            catch (Exception ex)
            {
                EventLogger.WriteLog(ConstantsResource.ErrorMessageSpecialityDescriptionGet, ex, new UserDetails(), LogMessage.PUMA_MESSAGE_1034);
            }
            return result;
        }
        #endregion
    }
}
