﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.Schemas
{
    public class Audit
    {
        /// <summary>
        /// Gets or sets the audit ID.
        /// </summary>
        /// <value>
        /// The audit ID.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.AutoGeneratedKey)]
        public int AuditID { get; set; }
        /// <summary>
        /// Gets or sets the user account.
        /// </summary>
        /// <value>
        /// The user account.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string UserAccount { get; set; }
        /// <summary>
        /// Gets or sets the MRN.
        /// </summary>
        /// <value>
        /// The MRN.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string Mrn { get; set; }
        /// <summary>
        /// Gets or sets the medicare number.
        /// </summary>
        /// <value>
        /// The medicare number.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string MedicareNumber { get; set; }
        /// <summary>
        /// Gets or sets the medicare number seq.
        /// </summary>
        /// <value>
        /// The medicare number seq.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string MedicareNumberSeq { get; set; }
        /// <summary>
        /// Gets or sets the name of the patient.
        /// </summary>
        /// <value>
        /// The name of the patient.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string PatientName { get; set; }
        /// <summary>
        /// Gets or sets the viewed date time.
        /// </summary>
        /// <value>
        /// The viewed date time.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime ViewedDateTime { get; set; }
        /// <summary>
        /// Gets or sets the episode ID.
        /// </summary>
        /// <value>
        /// The episode ID.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public int? EpisodeID { get; set; }
        /// <summary>
        /// Gets or sets the device ID.
        /// </summary>
        /// <value>
        /// The device ID.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string DeviceID { get; set; }
    }
}
