﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.Schemas
{
    [Serializable]
    public class BaseDatabaseAccessSchemas
    {
        #region properties
        // Summary:
        //     Gets/Set the Date and Time that this record was created
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime DateCreated { get; set; }
        //
        // Summary:
        //     Gets/set the Date and Time that this record was last modified
        [DataBaseInfoAttributes(DatabaseColumnType.UpdateData)]
        public DateTime DateModified { get; set; }
        //
        // Summary:
        //     Get/Set the user who created this record
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string UserCreated { get; set; }
        //
        // Summary:
        //     Gets/Set the user who last modified this record
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public virtual string UserModified { get; set; }
        #endregion
  
    }
}
