﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Clinical Synopsis Item
    /// </summary>
    [Serializable]
    public class ClinicalSynopsis : BaseSchema
    {
        #region Private Members
        private string description;
        private int episodeId;
        #endregion

        /// <summary>
        /// Gets or sets the menu id.
        /// </summary>
        /// <value>
        /// The menu id.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? ClinicalSynopsisId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
        /// <summary>
        /// Gets or sets the episode id.
        /// </summary>
        /// <value>
        /// The episode id.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public int EpisodeId
        {
            get
            {
                return this.episodeId;
            }
            set
            {
                this.episodeId = value;
            }
        }


        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        /// <value>
        /// The description.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string Description
        {
            get
            {
                return this.description;
            }
            set
            {
                this.description = value;
            }
        }
    }
}
