﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;
using HIPS.PcehrDataStore.Schemas;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Configuration Item
    /// </summary>
    [Serializable]
    public class Configuration : BaseSchema
    {
        #region Private Members
        private Hospital currentHospital;
        private string currentWard;
        private int ihiIgnoreDischargedPatientDays;
        #endregion


        /// <summary>
        /// Gets or sets the configuration id.
        /// </summary>
        /// <value>
        /// The configuration id.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? ConfigurationId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }


        /// <summary>
        /// Gets or sets the current hospital.
        /// </summary>
        /// <value>
        /// The current hospital.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public Hospital CurrentHospital
        {
            get
            {
                return this.currentHospital;
            }
            set
            {
                this.currentHospital = value;
            }
        }

        /// <summary>
        /// Gets or sets the current ward.
        /// </summary>
        /// <value>
        /// The current ward.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string CurrentWard
        {
            get
            {
                return this.currentWard;
            }
            set
            {
                this.currentWard = value;
            }
        }

        /// <summary>
        /// Gets or sets the maximum number of days after a patient has been discharged from hospital that IHI's
        /// Should still be searched for.
        /// </summary>
        /// <value>
        /// The ihi ignore discharged patient days.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public int IhiIgnoreDischargedPatientDays
        {
            get
            {
                return this.ihiIgnoreDischargedPatientDays;
            }
            set
            {
                this.ihiIgnoreDischargedPatientDays = value;
            }
        }
    }
}
