﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using GalaSoft.MvvmLight.Messaging;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a type of an IHI Check List Item
    /// </summary>
    [Serializable]
    public class EpisodeIhiCheckList : BaseSchema
    {
        #region Private Members
        private int episodeId;
        private int checkListId;
        private string description;
        private string comments;
        private bool markForInstantRemoval;
        private bool allowNotes;
        private bool areNotesManditory;
        private bool isChecked;
        private string notes;
        #endregion

        /// <summary>
        /// Gets or sets the name type id.
        /// </summary>
        /// <value>
        /// The name type id.
        /// </value>
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int EpisodeId
        {
            get
            {
                return this.episodeId;
            }
            set
            {
                Set(() => EpisodeId, ref this.episodeId, value);
            }
        }
        /// <summary>
        /// Gets or sets the check list id.
        /// </summary>
        /// <value>
        /// The check list id.
        /// </value>
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.ApplicationGeneratedKey)]
        public int IhiCheckListId
        {
            get
            {
                return this.checkListId;
            }
            set
            {
                Set(() => IhiCheckListId, ref this.checkListId, value);
                Messenger.Default.Send<bool>(true, "CheckStatus");
            }
        }
        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        /// <value>
        /// The description.
        /// </value>
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.ReadOnlyData)]
        public string Description
        {
            get
            {
                return this.description;
            }
            set
            {
                this.description = value;
            }
        }
        /// <summary>
        /// Gets or sets the comments.
        /// </summary>
        /// <value>
        /// The comments.
        /// </value>
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.ReadOnlyData)]
        public string Comments
        {
            get
            {
                return this.comments;
            }
            set
            {
                this.comments = value;
            }
        }
        /// <summary>
        /// Gets or sets a value indicating whether [mark for instant removal].
        /// </summary>
        /// <value>
        /// <c>true</c> if [mark for instant removal]; otherwise, <c>false</c>.
        /// </value>
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.ReadOnlyData)]
        public bool MarkForInstantRemoval
        {
            get
            {
                return this.markForInstantRemoval;
            }
            set
            {
                this.markForInstantRemoval = value;
            }
        }
        /// <summary>
        /// Gets or sets a value indicating whether [allow notes].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [allow notes]; otherwise, <c>false</c>.
        /// </value>
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.ReadOnlyData)]
        public bool AllowNotes
        {
            get
            {
                return this.allowNotes; ;
            }
            set
            {
                this.allowNotes = value;
            }
        }
        /// <summary>
        /// Gets or sets a value indicating whether [are notes manditory].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [are notes manditory]; otherwise, <c>false</c>.
        /// </value>
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.ReadOnlyData)]
        public bool AreNotesManditory
        {
            get
            {
                return this.areNotesManditory; ;
            }
            set
            {
                this.areNotesManditory = value;
            }
        }
        /// <summary>
        /// Gets or sets a value indicating whether this instance is checked.
        /// </summary>
        /// <value>
        /// <c>true</c> if this instance is checked; otherwise, <c>false</c>.
        /// </value>
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.Data)]
        public bool IsChecked
        {
            get
            {
                return this.isChecked; ;
            }
            set
            {
                Set(() => IsChecked, ref this.isChecked, value);
            }
        }
        /// <summary>
        /// Gets or sets the notes.
        /// </summary>
        /// <value>
        /// The notes.
        /// </value>
        [DataBaseInfoAttributes(HIPS.Base.Schemas.Enumerators.DatabaseColumnType.Data)]
        public string Notes
        {
            get
            {
                return this.notes;
            }
            set
            {
                Set(() => Notes, ref this.notes, value);
            }
        }
    }
}
