﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;
using System.Runtime.Serialization;
using HIPS.PcehrDataStore.Schemas;
using Enumerators = HIPS.PcehrDataStore.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a PUMA view of an episode for displaying in a tile or list
    /// </summary>
    [KnownType(typeof(EpisodeTile))]
    [DataContract]
    [Serializable]
    public class EpisodeTile
    {
        #region Private Members
        #endregion
        #region Properties
        /// <summary>
        /// Gets or sets the episode id.
        /// </summary>
        /// <value>
        /// The episode id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public int EpisodeId { get; set; }
        /// <summary>
        /// Gets or sets the admission date.
        /// </summary>
        /// <value>
        /// The admission date.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public DateTime AdmissionDate { get; set; }
        /// <summary>
        /// Gets or sets the discharge date.
        /// </summary>
        /// <value>
        /// The discharge date.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public DateTime DischargeDate { get; set; }
        /// <summary>
        /// Gets or sets the admission reason.
        /// </summary>
        /// <value>
        /// The admission reason.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string AdmissionReason { get; set; }
        /// <summary>
        /// Gets or sets the name of the responsible provider family.
        /// </summary>
        /// <value>
        /// The name of the responsible provider family.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderFamilyName { get; set; }
        /// <summary>
        /// Gets or sets the responsible provider given names.
        /// </summary>
        /// <value>
        /// The responsible provider given names.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderGivenNames { get; set; }
        /// <summary>
        /// Gets or sets the responsible provider title.
        /// </summary>
        /// <value>
        /// The responsible provider title.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string ResponsibleProviderTitle { get; set; }
        /// <summary>
        /// Gets or sets the queue operation id.
        /// </summary>
        /// <value>
        /// The queue operation id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public int QueueOperationId { get; set; }
        /// <summary>
        /// Gets or sets the queue status id.
        /// </summary>
        /// <value>
        /// The queue status id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public int QueueStatusId { get; set; }
        /// <summary>
        /// Gets or sets the clinical document id.
        /// </summary>
        /// <value>
        /// The clinical document id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public int ClinicalDocumentId { get; set; }
        /// <summary>
        /// Gets or sets the clinical document status id.
        /// </summary>
        /// <value>
        /// The clinical document status id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public int ClinicalDocumentStatusId { get; set; }
        /// <summary>
        /// Gets or sets the document status.
        /// </summary>
        /// <value>
        /// The document status.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string DocumentStatus { get; set; }
        /// <summary>
        /// Gets or sets the source system set id of the document.
        /// </summary>
        /// <value>
        /// The source system set id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string SourceSystemSetId { get; set; }
        /// <summary>
        /// Gets the responsible provider.
        /// </summary>
        /// <value>
        /// The responsible provider.
        /// </value>
        public string ResponsibleProvider
        {
            get
            {
                return GetResponsibleProvider();
            }
        }

        /// <summary>
        /// Gets the document queue status.
        /// </summary>
        /// <value>
        /// The document queue status.
        /// </value>
        public string DocumentQueueStatus
        {
            get
            {
                string result;
                switch (ClinicalDocumentStatusId)
                {
                    case (int)Enumerators.ClinicalDocumentStatus.Active:
                        result = EpisodeTileResources.ActiveString;
                        break;
                    case (int)Enumerators.ClinicalDocumentStatus.Removed:
                        result = Enumerators.ClinicalDocumentStatus.Removed.ToString();
                        break;
                    default:
                        result = string.Empty;
                        break;
                }

                if (String.IsNullOrEmpty(result) || QueueOperationId == (int)Enumerators.QueueOperation.Remove)
                {
                    switch (QueueStatusId)
                    {
                        case (int)Enumerators.QueueStatus.Pending:
                            result = Enumerators.QueueStatus.Pending.ToString();
                            break;
                        case (int)Enumerators.QueueStatus.Failure:
                            result = Enumerators.QueueStatus.Failure.ToString();
                            break;
                        default:
                            result = "Unknown";
                            break;
                    }
                }

                return result;
            }
        }
        /// <summary>
        /// Gets or sets the consent withdrawn.
        /// </summary>
        /// <value>
        /// The consent withdrawn.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public bool ConsentWithdrawn { get; set; }

        #endregion
        #region Methods
        /// <summary>
        /// Gets the responsible provider.
        /// </summary>
        /// <returns></returns>
        private string GetResponsibleProvider()
        {
            StringBuilder name = new StringBuilder();

            if (!string.IsNullOrEmpty(ResponsibleProviderTitle))
            {
                name.Append(string.Format("{0} ", ResponsibleProviderTitle.Trim()));
            }

            if (!string.IsNullOrEmpty(ResponsibleProviderGivenNames))
            {
                name.Append(string.Format("{0} ", ResponsibleProviderGivenNames.Trim()));
            }

            if (!string.IsNullOrEmpty(ResponsibleProviderFamilyName))
            {
                name.Append(ResponsibleProviderFamilyName.Trim());
            }

            return name.ToString();
        }

        #endregion
    }
}
