﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a PUMA help page.
    /// </summary>
    [KnownType(typeof(HelpPageDetail))]
    [DataContract]
    [Serializable]
    public class HelpPageDetail
    {
        #region Properties

        /// <summary>
        /// Gets or sets the help page id.
        /// </summary>
        /// <value>
        /// The help page id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public int HelpPageId { get; set; }

        /// <summary>
        /// Gets or sets the name of the help page.
        /// </summary>
        /// <value>
        /// The name of the help page.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string HelpPageName { get; set; }

        /// <summary>
        /// Gets or sets the help page detail id.
        /// </summary>
        /// <value>
        /// The help page detail id.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public int HelpPageDetailId { get; set; }

        /// <summary>
        /// Gets or sets the section title.
        /// </summary>
        /// <value>
        /// The section title.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string SectionTitle { get; set; }

        /// <summary>
        /// Gets or sets the section text.
        /// </summary>
        /// <value>
        /// The section text.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string SectionText { get; set; }

        #endregion
    }
}
