﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Menu Item
    /// </summary>
    [Serializable]
    public class Menu : BaseSchema
    {
        #region Private Members
        private bool onMainMenu;
        private bool onSubMenu;
        private string title;
        private string description;
        private string glyph;
        private string dischargeStatusGlyph;
        private string view;
        private int sequence;
        #endregion

        /// <summary>
        /// Gets or sets the menu id.
        /// </summary>
        /// <value>
        /// The menu id.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.ApplicationGeneratedKey)]
        public int? MenuId
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
        /// <summary>
        /// Gets or sets a value indicating whether [on main menu].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [on main menu]; otherwise, <c>false</c>.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public bool OnMainMenu
        {
            get
            {
                return this.onMainMenu;
            }
            set
            {
                this.onMainMenu = value;
            }
        }
        /// <summary>
        /// Gets or sets a value indicating whether [on sub menu].
        /// </summary>
        /// <value>
        ///   <c>true</c> if [on sub menu]; otherwise, <c>false</c>.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public bool OnSubMenu
        {
            get
            {
                return this.onSubMenu;
            }
            set
            {
                this.onSubMenu = value;
            }
        }
        /// <summary>
        /// Gets or sets the title, the main title of the menu item.
        /// </summary>
        /// <value>
        /// The title.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string Title
        {
            get
            {
                return this.title;
            }
            set
            {
                this.title = value;
            }
        }
        /// <summary>
        /// Gets or sets the description, a short description of what the menu entry is about.
        /// </summary>
        /// <value>
        /// The description.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string Description
        {
            get
            {
                return this.description;
            }
            set
            {
                this.description = value;
            }
        }

        /// <summary>
        /// Gets or sets the glyph - The menus item icon (Font Code).
        /// </summary>
        /// <value>
        /// The glyph.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string Glyph
        {
            get
            {
                return this.glyph;
            }
            set
            {
                this.glyph = value;
            }
        }
        /// <summary>
        /// Gets or sets the sequence that the menu item appears in the list.
        /// </summary>
        /// <value>
        /// The sequence.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public int Sequence
        {
            get
            {
                return this.sequence;
            }
            set
            {
                this.sequence = value;
            }
        }
        /// <summary>
        /// Gets or sets the view name.
        /// </summary>
        /// <value>
        /// The view.
        /// </value>
        [DataBaseInfoAttributes(DatabaseColumnType.Data)]
        public string View
        {
            get
            {
                return this.view;
            }
            set
            {
                this.view = value;
            }
        }

        public string DischargeStatusGlyph
        {
            get
            {
                return this.dischargeStatusGlyph;
            }
            set
            {
                this.dischargeStatusGlyph = value;
            }
        }
    }
}
