﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a patients diagnosis details
    /// </summary>
    [Serializable]
    public class PatientDiagnosis : BaseSchema
    {
        /// <summary>
        /// Gets or sets the diagnosis id.
        /// </summary>
        /// <value>
        /// The diagnosis id.
        /// </value>
        public int? DiagnosisID
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
        /// <summary>
        /// Gets or sets the episode id.
        /// </summary>
        /// <value>
        /// The episode id.
        /// </value>
        public int EpisodeID { get; set; }
        /// <summary>
        /// Gets or sets the diagnosis code.
        /// </summary>
        /// <value>
        /// The diagnosis code.
        /// </value>
        public string DiagnosisCode { get; set; }
        /// <summary>
        /// Gets or sets the description.
        /// </summary>
        /// <value>
        /// The description.
        /// </value>
        public string Description { get; set; }
        /// <summary>
        /// Gets or sets the type code.
        /// </summary>
        /// <value>
        /// The type code.
        /// </value>
        public string TypeCode { get; set; }
        /// <summary>
        /// Gets or sets the type description.
        /// </summary>
        /// <value>
        /// The type description.
        /// </value>
        public string TypeDescription { get; set; }
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        public int PatientID { get; set; }
    }
}
