﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using BaseEnumerators = HIPS.Base.Schemas.Enumerators;
using System.Runtime.Serialization;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a PUMA extended Patient Master
    /// </summary>
    [KnownType(typeof(PatientMaster))]
    [Serializable]
    [DataContract]
    public class PatientMaster : HIPS.PcehrDataStore.Schemas.PatientMaster
    {
        #region private Members
        private string registeredSex;
        #endregion
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.ReadOnlyData)]
        public string RegisteredSex
        {
            get
            {
                return this.registeredSex;
            }
            set
            {
                Set(() => RegisteredSex, ref this.registeredSex, value);
            }
        }

        /// <summary>
        /// Gets the medicare card in the correct format.
        /// </summary>
        /// <value>
        /// The medicare card.
        /// </value>
        public string MedicareCard
        {
            get
            {
                if (!string.IsNullOrWhiteSpace(MedicareNumber))
                {
                    if (!string.IsNullOrWhiteSpace(MedicareIrn))
                    {
                        return string.Format("{0} {1} {2}-{3}", MedicareNumber.Substring(0, 3), MedicareNumber.Substring(3, 3), MedicareNumber.Substring(6, 4), MedicareIrn);
                    }
                    else
                    {
                        return string.Format("{0} {1} {2}", MedicareNumber.Substring(0, 3), MedicareNumber.Substring(3, 3), MedicareNumber.Substring(6, 4));
                    }
                }
                return string.Empty;
            }
        }

        /// <summary>
        /// Gets the dva in it's correct format.
        /// </summary>
        /// <value>
        /// The dva.
        /// </value>
        public string Dva
        {
            get
            {
                if (!string.IsNullOrWhiteSpace(DvaNumber))
                {
                    return DvaNumber;
                    //return string.Format("{0} {1} {2}", DvaNumber.Substring(0, 3), DvaNumber.Substring(3, 3), DvaNumber.Substring(6, 4));
                }
                return string.Empty;
            }
        }
        /// <summary>
        /// Gets the formatted ihi.
        /// </summary>
        /// <value>
        /// The formatted ihi.
        /// </value>
        public string FormattedIhi
        {
            get
            {
                if (!string.IsNullOrWhiteSpace(Ihi))
                {
                    //TODO: To resolve
                    return "1234-5678-9012-3456";
                    //return string.Format("{0} {1} {2} {4}", Ihi.Substring(0, 4), Ihi.Substring(3, 4), Ihi.Substring(7, 4), Ihi.Substring(11, 4));
                }
                return string.Empty;
            }
        }
        /// <summary>
        /// Gets or sets the language spoken.
        /// </summary>
        /// <value>
        /// The language spoken.
        /// </value>
        //[DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        //public string LanguageSpoken { get; set; }

        /// <summary>
        /// Gets or sets the country of birth ID.
        /// </summary>
        /// <value>
        /// The country of birth ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int CountryOfBirthId { get; set; }

        /// <summary>
        /// Gets or sets the marital status ID.
        /// </summary>
        /// <value>
        /// The marital status ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int MaritalStatusId { get; set; }

        /// <summary>
        /// Gets or sets the indigenous status ID.
        /// </summary>
        /// <value>
        /// The indigenous status ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int IndigenousStatusId { get; set; }

        /// <summary>
        /// Gets or sets the religion ID.
        /// </summary>
        /// <value>
        /// The religion ID.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(BaseEnumerators.DatabaseColumnType.Data)]
        public int ReligionId { get; set; }
    }
}
