﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;
using System.Runtime.Serialization;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Patient without an IHI that has yet to be checked
    /// </summary>
    [Serializable]
    [KnownType(typeof(PatientsMissingIhiReport))]
    [DataContract]
    public class PatientsMissingIhiReport
    {
        /// <summary>
        /// Gets or sets the given names.
        /// </summary>
        /// <value>
        /// The given names.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string GivenNames { get; set; }
        /// <summary>
        /// Gets or sets the name of the family.
        /// </summary>
        /// <value>
        /// The name of the family.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string FamilyName { get; set; }
        /// <summary>
        /// Gets or sets the MRN.
        /// </summary>
        /// <value>
        /// The MRN.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Mrn { get; set; }
        /// <summary>
        /// Gets or sets the sex.
        /// </summary>
        /// <value>
        /// The sex.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Sex { get; set; }
        /// <summary>
        /// Gets or sets the medicare number.
        /// </summary>
        /// <value>
        /// The medicare number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string MedicareNumber { get; set; }
        /// <summary>
        /// Gets or sets the medicare irn.
        /// </summary>
        /// <value>
        /// The medicare irn.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string MedicareIrn { get; set; }
        /// <summary>
        /// Gets or sets the dva number.
        /// </summary>
        /// <value>
        /// The dva number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string DvaNumber { get; set; }
        /// <summary>
        /// Gets or sets the date of birth.
        /// </summary>
        /// <value>
        /// The date of birth.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime DateOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the ward.
        /// </summary>
        /// <value>
        /// The ward.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Ward { get; set; }
    }
}
