﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;
using HIPS.Base.Schemas.Enumerators;
using System.Runtime.Serialization;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a Patient that has had data changed in PUMA, but not in the corresponding PAS
    /// </summary>
    [Serializable]
    [KnownType(typeof(PatientsWithOverridesReport))]
    [DataContract]
    public class PatientsWithOverridesReport
    {
        /// <summary>
        /// Gets or sets the given names.
        /// </summary>
        /// <value>
        /// The given names.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string GivenNames { get; set; }
        /// <summary>
        /// Gets or sets the name of the family.
        /// </summary>
        /// <value>
        /// The name of the family.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string FamilyName { get; set; }
        /// <summary>
        /// Gets or sets the MRN.
        /// </summary>
        /// <value>
        /// The MRN.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string Mrn { get; set; }
        /// <summary>
        /// Gets or sets the pas medicare number.
        /// </summary>
        /// <value>
        /// The pas medicare number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string PasMedicareNumber { get; set; }
        /// <summary>
        /// Gets or sets the new medicare number.
        /// </summary>
        /// <value>
        /// The new medicare number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string NewMedicareNumber { get; set; }
        /// <summary>
        /// Gets or sets the pas medicare irn.
        /// </summary>
        /// <value>
        /// The pas medicare irn.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string PasMedicareIrn { get; set; }
        /// <summary>
        /// Gets or sets the new medicare irn.
        /// </summary>
        /// <value>
        /// The new medicare irn.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string NewMedicareIrn { get; set; }
        /// <summary>
        /// Gets or sets the pas dva number.
        /// </summary>
        /// <value>
        /// The pas dva number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string PasDvaNumber { get; set; }
        /// <summary>
        /// Gets or sets the new dva number.
        /// </summary>
        /// <value>
        /// The new dva number.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public string NewDvaNumber { get; set; }
        /// <summary>
        /// Gets or sets the pas date of birth.
        /// </summary>
        /// <value>
        /// The pas date of birth.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime PasDateOfBirth { get; set; }
        /// <summary>
        /// Gets or sets the new date of birth.
        /// </summary>
        /// <value>
        /// The new date of birth.
        /// </value>
        [DataMember]
        [DataBaseInfoAttributes(DatabaseColumnType.ReadOnlyData)]
        public DateTime? NewDateOfBirth { get; set; }
    }
}
