﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents an episode procedure - Not sure it is used
    /// </summary>
    [Serializable]
    public class Procedure : BaseSchema
    {
        /// <summary>
        /// Gets or sets the procedure id.
        /// </summary>
        /// <value>
        /// The procedure id.
        /// </value>
        public int ProcedureID { get; set; }
        /// <summary>
        /// Gets or sets the episode id.
        /// </summary>
        /// <value>
        /// The episode id.
        /// </value>
        public int EpisodeID { get; set; }
        /// <summary>
        /// Gets or sets the icd type code.
        /// </summary>
        /// <value>
        /// The icd type code.
        /// </value>
        public string IcdTypeCode { get; set; }
        /// <summary>
        /// Gets or sets the icd type description.
        /// </summary>
        /// <value>
        /// The icd type description.
        /// </value>
        public string IcdTypeDescription { get; set; }
        /// <summary>
        /// Gets or sets the episode procedure type description.
        /// </summary>
        /// <value>
        /// The episode procedure type description.
        /// </value>
        public string EpisodeProcedureTypeDescription { get; set; }
        /// <summary>
        /// Gets or sets the episode procedure type code.
        /// </summary>
        /// <value>
        /// The episode procedure type code.
        /// </value>
        public string EpisodeProcedureTypeCode { get; set; }
        /// <summary>
        /// Gets or sets the patient id.
        /// </summary>
        /// <value>
        /// The patient id.
        /// </value>
        public string PatientID { get; set; }
    }
}
