﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents a patinets radiology result - Not used in this phase (removed from scope)
    /// </summary>
    [Serializable]
    public class Radiology : BaseInformationSchema
    {
        /// <summary>
        /// Gets or sets the radiology id.
        /// </summary>
        /// <value>
        /// The radiology id.
        /// </value>
        public int? RadiologyID
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
        /// <summary>
        /// Gets or sets the paitient id.
        /// </summary>
        /// <value>
        /// The paitient id.
        /// </value>
        public int PaitientID { get; set; }
        /// <summary>
        /// Gets or sets the recieving facility.
        /// </summary>
        /// <value>
        /// The recieving facility.
        /// </value>
        public string RecievingFacility { get; set; }
        /// <summary>
        /// Gets or sets the message date.
        /// </summary>
        /// <value>
        /// The message date.
        /// </value>
        public DateTime MessageDate { get; set; }
        /// <summary>
        /// Gets or sets the name of the service.
        /// </summary>
        /// <value>
        /// The name of the service.
        /// </value>
        public string ServiceName { get; set; }
        /// <summary>
        /// Gets or sets the ordering provider.
        /// </summary>
        /// <value>
        /// The ordering provider.
        /// </value>
        public string OrderingProvider { get; set; }
        /// <summary>
        /// Gets or sets the report.
        /// </summary>
        /// <value>
        /// The report.
        /// </value>
        public string Report { get; set; }
    }
}
