﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using HIPS.Base.Schemas;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// This class represents the stored version of the radiology image - Taken out of scope for now
    /// </summary>
    public class RadiologyImage : BaseSchema
    {
        /// <summary>
        /// Gets or sets the radiology image id.
        /// </summary>
        /// <value>
        /// The radiology image id.
        /// </value>
        public int? RadiologyImageID
        {
            get
            {
                return base.Id;
            }
            set
            {
                base.Id = value;
            }
        }
        /// <summary>
        /// Gets or sets the radiology id.
        /// </summary>
        /// <value>
        /// The radiology id.
        /// </value>
        public int RadiologyID { get; set; }
        /// <summary>
        /// Gets or sets the digital image.
        /// </summary>
        /// <value>
        /// The digital image.
        /// </value>
        public byte[] DigitalImage { get; set; }
        /// <summary>
        /// Gets or sets the image.
        /// </summary>
        /// <value>
        /// The image.
        /// </value>
        public string Image { get; set; }
    }
}
