﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ComponentModel;
using HIPS.Base.Schemas.Enumerators;

namespace PUMA.PcehrDataStore.Schemas
{
    /// <summary>
    /// The security object of the logged in user
    /// </summary>
    public class Security : INotifyPropertyChanged
    {
        #region Private Members
        private bool canEdit = false;
        #endregion

        /// <summary>
        /// Gets or sets the login - AD Account.
        /// </summary>
        /// <value>
        /// The login.
        /// </value>
        public  string Login { get; set; }
        /// <summary>
        /// Gets or sets the name of the person logged in.
        /// </summary>
        /// <value>
        /// The name.
        /// </value>
        public  string Name { get; set; }
        /// <summary>
        /// Gets or sets the hpi I of the person logged in.
        /// </summary>
        /// <value>
        /// The hpi I.
        /// </value>
        public  string HpiI { get; set; }
        /// <summary>
        /// Gets or sets the group that the user hass access to.
        /// </summary>
        /// <value>
        /// The group.
        /// </value>
        public  SecurityGroup Group { get; set; }


        public string FamilyName
        {
            get
            {
                return "TBC:Family Name";
            }
        }

        public string Title
        {
            get
            {
                return "TBC:Title";
            }
        }

        public List<string> GivenNames
        {
            get
            {
                return new List<string> { "TBC:Given Names" };
            }
        }

        /// <summary>
        /// Gets or sets a value indicating whether this user can edit.
        /// </summary>
        /// <value>
        ///   <c>true</c> if this instance can edit; otherwise, <c>false</c>.
        /// </value>
        public bool CanEdit
        {
            get
            {
                return canEdit;
            }
            set
            {
                canEdit = value;
                OnPropertyChanged("CanEdit");
            }
        }

        #region Proprty Changed Events
        [field: NonSerialized]
        public event PropertyChangedEventHandler PropertyChanged;

        protected void OnPropertyChanged(String info)
        {
            PropertyChangedEventHandler handler = PropertyChanged;
            if (handler != null)
            {
                handler(this, new PropertyChangedEventArgs(info));
            }
        }
        #endregion
    }
}
