﻿/****** Object:  StoredProcedure [puma].[PatientTileGet]    Script Date: 06/20/2013 10:12:00 ******/
DROP PROCEDURE [puma].[PatientTileGet]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
-- =============================================
-- Author:        Andrew Jacks
-- Create date:	  21 November 2012
-- Description:   Gets a list of patients for a hospital/all hospitals
-- Note: Discharge date is the for only getting patients discharged after this date
-- Modified: 23/05/2013 Kirby Bettison Remove patients with MedicareNumbers in the MedicareExclusion table
--                                     Remove patients that are less than 1 month old
--			 19/07/2013 Simon Biber    
--			 09/10/2013 Russell Lescai	Assisted Reg: Added Filter for patients without a PCEHR.
-- =============================================
CREATE PROCEDURE [puma].[PatientTileGet] 
(
	@HospitalId INT = NULL,
	@OnlyUserToSearchForIhi BIT = NULL,
	@HaveIhi BIT = NULL,
	@Ward VARCHAR(40) = NULL,
	@DischargeDate DATETIME = NULL,
	@PcehrPatients BIT = NULL,
	@WithoutPcehrPatients BIT = NULL
)
AS
BEGIN
SELECT  ptv.HospitalId,
		ptv.GivenNames,
		ptv.FamilyName,
		ptv.Mrn,
		ptv.PatientMasterId,
		ptv.PatientId,
		ptv.CurrentSexId,
		ptv.DateOfBirth,
		ptv.DateOfDeath,
		ptv.IhiInvestigationComplete,
		ptv.Ihi,
		ptv.PcehrAdvertised,
		ptv.PcehrDisclosed,
		ptv.ConsentWithdrawn,
		ptv.Ward,
		ptv.AdmissionDate,
		ptv.EpisodeId,
		ptv.DischargeDate,
		(SELECT COUNT(*) FROM puma.EpisodeView WHERE PatientId = ptv.PatientId) as EpisodeCount
		
FROM  puma.PatientTileView ptv
WHERE (ptv.HospitalId = @HospitalId OR @HospitalId IS NULL)
AND   (ptv.Ward = @Ward or @Ward IS NULL)
AND    (@OnlyUserToSearchForIhi IS NULL 
			OR @OnlyUserToSearchForIhi = 0 
			OR (@OnlyUserToSearchForIhi = 1 
				AND ((ptv.IhiInvestigationComplete != 1 OR ptv.IhiInvestigationComplete IS NULL) AND (ptv.Ihi IS NULL OR ptv.Ihi = '' ))
				AND NOT EXISTS (SELECT * FROM [hips].MedicareExclusion Where MedicareNumber = ptv.MedicareNumber)
				AND ptv.DateOfBirth < DATEADD(m, -1, GETDATE())
				AND (ptv.IhiStatusId is null or ptv.IhiStatusId != 103)
			)
		)
AND    (@HaveIhi IS NULL OR (@HaveIhi = 1 AND (ptv.Ihi IS NOT NULL AND ptv.Ihi != '' ))
						 OR (@HaveIhi = 0 AND (ptv.Ihi IS NULL OR ptv.Ihi = '' )))
AND   ((@DischargeDate IS NULL) OR (ptv.DischargeDate IS NULL) OR (@DischargeDate IS NOT NULL AND ptv.DischargeDate > @DischargeDate))
AND    ((@PcehrPatients IS NULL OR @PcehrPatients = 0) OR (@PcehrPatients = 1 AND ((ptv.PcehrAdvertised = 1) OR (ptv.PcehrDisclosed = 1))))
AND    ((@WithoutPcehrPatients IS NULL OR @WithoutPcehrPatients = 0) OR (@WithoutPcehrPatients = 1 AND NOT((ptv.PcehrAdvertised = 1) OR (ptv.PcehrDisclosed = 1))))
ORDER BY ptv.FamilyName, ptv.GivenNames
END
GO
