﻿
-- Author: Russell Lescai
-- Date: 09/10/2013
-- Description: Data update script for Assisted Registration functionality.

PRINT 'Inserting data...'
PRINT GETDATE()

-- Create HAD Group for Assisted Registration.
PRINT 'Creating HAD Group...'
SET IDENTITY_INSERT [puma].[HadGroup] ON
IF NOT EXISTS (SELECT * FROM [puma].[HadGroup] WHERE HadGroupId = 10)
	INSERT [puma].[HadGroup] ([HadGroupId], [HadGroupName], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, N'G-HAD-APP-PUMA-AssistedReg', CAST(0x0000A17100BA8F27 AS DateTime), N'PUMA', CAST(0x0000A17100BA8F27 AS DateTime), N'PUMA')
SET IDENTITY_INSERT [puma].[HadGroup] OFF

-- Create Assisted Registration functional permission.
PRINT 'Creating Functional Permission...'
SET IDENTITY_INSERT [puma].[FunctionalPermission] ON
IF NOT EXISTS (SELECT * FROM [puma].[FunctionalPermission] WHERE FunctionalPermissionId = 14)
	INSERT [puma].[FunctionalPermission] ([FunctionalPermissionId], [FunctionalPermissionName], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (14, N'AssistedRegistrationAccess', CAST(0x0000A17100A8F9B8 AS DateTime), N'PUMA', CAST(0x0000A17100A8F9B8 AS DateTime), N'PUMA')
SET IDENTITY_INSERT [puma].[FunctionalPermission] OFF

-- Create Menu item for patients without a PCEHR.
PRINT 'Creating Menu Item...'
SET IDENTITY_INSERT [puma].[Menu] ON
IF NOT EXISTS (SELECT * FROM [puma].[Menu] WHERE MenuId = 12)
	INSERT [puma].[Menu] ([MenuId], [OnMainMenu], [OnSubMenu], [Title], [Description], [Glyph], [View], [Sequence], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, NULL, NULL, N'Patients With No National eHealth Record', N'Lists all patients in hospital, or recently discharged that do not have a National eHealth Record (PCEHR).', N'E1E2', N'../View/PcehrWithoutPatientView.xaml', 6, CAST(0x0000901A00000000 AS DateTime), N'Andrew', CAST(0x0000901A00000000 AS DateTime), N'Andrew')
SET IDENTITY_INSERT [puma].[Menu] OFF

-- Assign Assisted Reg Functional permission to menu item.
PRINT 'Assigning Permission to Menu Item...'
IF NOT EXISTS (SELECT * FROM [puma].[MenuFunctionalPermission] WHERE MenuId = 12 AND FunctionalPermissionId = 14)
	INSERT [puma].[MenuFunctionalPermission] ([MenuId], [FunctionalPermissionId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (12, 14, CAST(0x0000A17200A9FC58 AS DateTime), N'PUMA', CAST(0x0000A17200A9FC58 AS DateTime), N'PUMA')

-- Assign Assisted Reg Functional permission to HAD Group.
PRINT 'Assigning Permission to HAD Group...'
IF NOT EXISTS (SELECT * FROM [puma].[HadGroupFunctionalPermission] WHERE HadGroupId = 10 AND FunctionalPermissionId = 14)
	INSERT [puma].[HadGroupFunctionalPermission] ([HadGroupId], [FunctionalPermissionId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (10, 14, CAST(0x0000A17100BC022B AS DateTime), N'PUMA', CAST(0x0000A17100BC022B AS DateTime), N'PUMA')

-- Assign Assisted Reg Functional permission to LMH Hospital.
PRINT 'Assigning Permission to Hospital...'
IF NOT EXISTS (SELECT * FROM [puma].[HospitalFunctionalPermission] WHERE HospitalId = 71 AND FunctionalPermissionId = 14)
	INSERT [puma].[HospitalFunctionalPermission] ([HospitalId], [FunctionalPermissionId], [DateCreated], [UserCreated], [DateModified], [UserModified]) VALUES (71, 14, CAST(0x0000A17100ABA4A0 AS DateTime), N'PUMA', CAST(0x0000A17100ABA4A0 AS DateTime), N'PUMA')

PRINT 'Script Complete.'
PRINT GETDATE()