﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Formatters.Binary;
using System.IO;
using System.Reflection;
using HIPS.Base.Schemas;

namespace PUMA.Schemas.Helpers
{
    public static class Schema
    {
        /// <summary>
        /// Clones the specified source.
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="source">The source.</param>
        /// <returns></returns>
        public static T Clone<T>(this T source)
        {
            if (!typeof(T).IsSerializable)
            {
                throw new ArgumentException("The type must be serializable.", "source");
            }

            // Don't serialize a null object, simply return the default for that object 
            if (Object.ReferenceEquals(source, null))
            {
                return default(T);
            }

            IFormatter formatter = new BinaryFormatter();
            Stream stream = new MemoryStream();
            using (stream)
            {
                formatter.Serialize(stream, source);
                stream.Seek(0, SeekOrigin.Begin);
                return (T)formatter.Deserialize(stream);
            }
        }

        /// <summary>
        /// Updates the specified target item. 
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="targetItem">The target item.</param>
        /// <param name="sourceItem">The source item.</param>
        public static void Update<T>(T targetItem, T sourceItem)
        {
            PropertyInfo[] fromFields = typeof(T).GetProperties();
            for (int count = 0; count < fromFields.Length; count++)
            {
                bool update = false;
                PropertyInfo fromField = (PropertyInfo)fromFields[count];
                object[] attributes = fromField.GetCustomAttributes(typeof(DataBaseInfoAttributes), false);
                foreach (DataBaseInfoAttributes attribute in attributes)
                {
                    if (attribute is DataBaseInfoAttributes)
                    {
                        update = true;
                        break;
                    }
                }

                if (fromField.CanWrite && update)
                {
                    //PropertyInfo toField = (PropertyInfo)toFields[count];
                    object value = fromField.GetValue(sourceItem, null);
                    fromField.SetValue(targetItem, value, null);
                }
            }
        }
    }
}
