﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.ServiceModel.Dispatcher;
using System.ServiceModel.Channels;
using System.ServiceModel;
using PUMA.Operation;
using PUMA.PcehrDataStore.DataAccess;

namespace PUMA.Security
{
    /// <summary>
    /// Provides access to the headers of all incoming and outgoing messages.
    /// </summary>
    public class PumaServiceHeaderMessageInspector : IDispatchMessageInspector
    {
        #region IDispatchMessageInspector Members

        /// <summary>
        /// Called after an inbound message has been received but before the message is dispatched to the intended operation.
        /// </summary>
        /// <param name="request">The request message.</param>
        /// <param name="channel">The incoming channel.</param>
        /// <param name="instanceContext">The current service instance.</param>
        /// <returns>
        /// The object used to correlate state. This object is passed back in the <see cref="M:System.ServiceModel.Dispatcher.IDispatchMessageInspector.BeforeSendReply(System.ServiceModel.Channels.Message@,System.Object)" /> method.
        /// </returns>
        public object AfterReceiveRequest(ref Message request, IClientChannel channel, InstanceContext instanceContext)
        {
            MessageHeaders headers = OperationContext.Current.IncomingMessageHeaders;
            Int32 hospitalId = headers.GetHeader<Int32>("HospitalIdentifier", "http://www.sahealth.gov.au");
            string ipAddress = headers.GetHeader<string>("IPAddress", "http://www.sahealth.gov.au");
            string machineName = headers.GetHeader<string>("MachineName", "http://www.sahealth.gov.au");

            PumaOperationContext.Current.HospitalId = hospitalId;
            PumaOperationContext.Current.IPAddress = ipAddress;
            PumaOperationContext.Current.MachineName = machineName;

            SecurityDl dataAccess = new SecurityDl();
            PumaOperationContext.Current.Permissions = dataAccess.GetUserPermission();

            return null;
        }

        /// <summary>
        /// Called after the operation has returned but before the reply message is sent.
        /// </summary>
        /// <param name="reply">The reply message. This value is null if the operation is one way.</param>
        /// <param name="correlationState">The correlation object returned from the <see cref="M:System.ServiceModel.Dispatcher.IDispatchMessageInspector.AfterReceiveRequest(System.ServiceModel.Channels.Message@,System.ServiceModel.IClientChannel,System.ServiceModel.InstanceContext)" /> method.</param>
        public void BeforeSendReply(ref Message reply, object correlationState)
        {
            var header = new MessageHeader<List<string>>(PumaOperationContext.Current.Permissions);
            //var header = new MessageHeader<List<string>>(PumaOperationContext.Current.Permissions);
            var untyped = header.GetUntypedHeader("Permissions", "http://www.sahealth.gov.au");
            reply.Headers.Add(untyped);
        }

        #endregion
    }
}
