﻿#region Using Directives
using System.ServiceModel;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.Generic;
using System;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.ObjectModel; 
#endregion

namespace PUMA.ServiceContracts.ServiceInterface
{
    [ServiceContract(Namespace = "http://schemas.PUMA/Services/2012/01", Name = "EpisodeIhiCheckListService")]
    public interface IEpisodeIhiCheckListService
    {

        /// <summary>
        /// Gets all the menu entries.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        ObservableCollection<EpisodeIhiCheckList> GetAll(int episodeId);

        /// <summary>
        /// Updates/Inserts the specified item.
        /// </summary>
        /// <param name="item">The item.</param>
        /// <returns></returns>
        [OperationContract]
        bool Update(EpisodeIhiCheckList item);

        /// <summary>
        /// Ihis the investigation completed.
        /// </summary>
        /// <param name="episodeId">The episode id.</param>
        [OperationContract]
        void IhiInvestigationCompleted(int episodeId);
    }
}
