﻿#region Using Directives
using System.ServiceModel;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.Generic;
using System;
using System.Collections.ObjectModel;
using PUMA.PcehrDataStore.Schemas;
using HIPS.CommonSchemas;
using HIPS.CommonSchemas.PatientIdentifier; 
#endregion

namespace PUMA.ServiceContracts.ServiceInterface
{
    [ServiceContract(Namespace = "http://schemas.PUMA/Services/2012/01", Name = "EpisodeService")]
    public interface IEpisodeService
    {
        /// <summary>
        /// Gets the specified episode id.
        /// </summary>
        /// <param name="episodeId">The episode id.</param>
        /// <returns></returns>
        [OperationContract]
        EpisodeTile Get(int episodeId);
        /// <summary>
        /// Gets the a list episodes with uploaded documents for a specific patient.
        /// </summary>
        /// <param name="patientId">The patient id.</param>
        /// <param name="startRow">The start row.</param>
        /// <param name="endRow">The end row.</param>
        /// <param name="user">The user.</param>
        /// <returns></returns>
        [OperationContract]
        ObservableCollection<EpisodeTile> GetEpisodesWithUploadedDocuments(int patientId, int startRow, int endRow);
        /// <summary>
        /// Gets the count of episodes with uploaded document for the selected patient.
        /// </summary>
        /// <param name="patientId">The patient id.</param>
        /// <param name="user">The user.</param>
        /// <returns></returns>
        [OperationContract]
        int GetEpisodesWithUploadedDocumentCount(int patientId);
        /// <summary>
        /// Gets a list of episodes for a specific patient.
        /// </summary>
        /// <param name="patientId">The patient id.</param>
        /// <param name="startRow">The start row.</param>
        /// <param name="endRow">The end row.</param>
        /// <returns></returns>
        [OperationContract]
        ObservableCollection<EpisodeTile> GetEpisodes(int patientId, int startRow, int endRow);
        /// <summary>
        /// Gets a count of episodes for the selected patient.
        /// </summary>
        /// <param name="patientId">The patient id.</param>
        /// <returns></returns>
        [OperationContract]
        int GetEpisodesCount(int patientId);

        /// <summary>
        ///  Records if the patient has withdrawn their consent to upload documents to the PCEHR for the current episode.
        /// </summary>
        /// <param name="pcehrWithdrawn">if set to <c>true</c> [pcehr withdrawn].</param>
        /// <param name="admissionDate">The admission date.</param>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="user">The user.</param>
        /// <param name="auditInformation">The audit information.</param>
        /// <returns></returns>
        [OperationContract]
        bool RecordConsent(bool pcehrWithdrawn, DateTime admissionDate, PatientIdentifierBase patientIdentifier, byte[] auditInformation);

        /// <summary>
        /// Gets the current consent reason.
        /// </summary>
        /// <param name="episodeId">The episode id.</param>
        /// <returns></returns>
        [OperationContract]
        string GetCurrentConsentReason(int episodeId);

    }
}
