﻿#region Using Directives
using System.ServiceModel;
using Nehta.VendorLibrary.PCEHR.RemoveDocument;
using HIPS.IhiSchemas.Schemas;
using HIPS.PcehrSchemas;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas.Enumerators;
using HIPS.CommonSchemas.PatientIdentifier;
using System;
using PUMA.PcehrDataStore.Schemas;
#endregion

namespace PUMA.ServiceContracts.ServiceInterface
{
    [ServiceContract(Namespace = "http://schemas.PUMA/Services/2012/01", Name = "HIPSService")]
    public interface IHIPSService
    {
        /// <summary>
        /// IHIs the search by number.
        /// </summary>
        /// <param name="searchDetails">The search details.</param>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="user">The user.</param>
        /// <returns></returns>
        [OperationContract]
        bool IHISearchByNumber(PUMA.PcehrDataStore.Schemas.PatientMaster patientMaster, int hospitalId, out string message);

        /// <summary>
        /// IHIs the search by number and PCEHR check.
        /// </summary>
        /// <param name="patientMaster">The patient master.</param>
        /// <param name="hospitalId">The hospital id.</param>
        /// <returns></returns>
        [OperationContract]
        bool IHISearchByNumberAndPCEHRCheck(PUMA.PcehrDataStore.Schemas.PatientMaster patientMaster, int hospitalId, out string message);

        /// <summary>
        /// Pcehrs the exists.
        /// </summary>
        /// <param name="ihi">The ihi.</param>
        /// <param name="user">The user.</param>
        /// <returns></returns>
        [OperationContract]
        DoesPcehrExistResponse PcehrExists(string ihi);

        /// <summary>
        /// PCEHRs the upload.
        /// </summary>
        /// <param name="package">The package.</param>
        /// <param name="ihi">The ihi.</param>
        /// <param name="user">The user.</param>
        /// <param name="parentDocumentId">The parent document id.</param>
        /// <returns></returns>
        [OperationContract]
        string PCEHRUpload(string package, string ihi, string parentDocumentId);

        /// <summary>
        /// Pcehrs the remove.
        /// </summary>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="admissionDate">The admission date.</param>
        /// <param name="documentId">The document id.</param>
        /// <param name="reason">The reason.</param>
        /// <param name="user">The user.</param>
        /// <param name="auditInformation">The audit information.</param>
        /// <returns></returns>
        [OperationContract]
        HipsResponse PcehrRemove(PatientIdentifierBase patientIdentifier, DateTime admissionDate, string documentId, RemovalReason reason, byte[] auditInformation);

        /// <summary>
        /// Gets the current remove reason.
        /// </summary>
        /// <param name="clinicalDocumentId">The clinical document id.</param>
        /// <returns></returns>
        [OperationContract]
        string GetCurrentRemoveReason(int clinicalDocumentId);
    }
}
