﻿#region Using Directives
using System.ServiceModel;
using System.Collections.Generic;
using HIPS.PcehrDataStore.Schemas;
using System;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.ObjectModel;
using HIPS.CommonSchemas; 
#endregion

namespace PUMA.ServiceContracts.ServiceInterface
{
    [ServiceContract(Namespace = "http://schemas.PUMA/Services/2012/01", Name = "HospitalService")]
    public interface IHospitalService
    {
        
        [OperationContract]
        List<Hospital> GetActive();

        [OperationContract]
        List<Hospital> GetAll();

        [OperationContract]
        List<Hospital> GetAllByDate(DateTime? lastUpdated);

        [OperationContract]
        Hospital Get(int hospitalId);

        [OperationContract]
        /// <summary>
        /// Gets all the wards with the selected Hospital or all hospitals if the id is null.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <returns></returns>
        ObservableCollection<HospitalWard> GetAllWards(int? hospitalId);

    }
}
