﻿#region Using Directives
using System.ServiceModel;
using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using PUMA.PcehrDataStore.Schemas; 
#endregion

namespace PUMA.ServiceContracts.ServiceInterface
{
    [ServiceContract(Namespace = "http://schemas.PUMA/Services/2012/01", Name = "PatientMasterService")]
    public interface IPatientMasterService
    {
        //[OperationContract]
        //List<PatientMaster> GetAll();
        
        [OperationContract]
        bool Get(int hospitalID, string mrn, int? namespaceId, string currentLastName, string currentFirstNames, DateTime? dateOfBirth, int? sexID, string medicareNumber, string medicareNumberSequence, string dvaNumber,bool? onlyCountryPatients, out PatientMaster item);

        /// <summary>
        /// Gets all patient tile details based on the search parameters passed in.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <param name="ward">The ward.</param>
        /// <param name="onlyShowPatientsNeededAManualIhiSearch">The only show patients needed A manual ihi search.</param>
        /// <param name="dischargeDate">The discharge date.</param>
        /// <param name="pcehrPatients">if set to <c>true</c> [pcehr patients].</param>
        /// <param name="withoutPcehrPatients">if set to <c>true</c> [non-pcehr patients].</param>
        /// <returns></returns>
        [OperationContract]
        ObservableCollection<PatientTile> GetAll(int? hospitalId, string ward, bool? onlyShowPatientsNeededAManualIhiSearch, bool pcehrPatients, bool withoutPcehrPatients);

        [OperationContract]
        ObservableCollection<PatientTile> GetAllPcehrByHospital(int hospitalId);

        [OperationContract]
        ObservableCollection<PatientTile> GetAllWithoutPcehrByHospital(int hospitalId);

        [OperationContract]
        bool GetById(int patientMasterID, out PatientMaster item);

        [OperationContract]
        ObservableCollection<PatientTile> GetByMrn(int hospitalId, string mrn);

        [OperationContract]
        bool Save(PatientMaster item);

        [OperationContract]
        bool Delete(PatientMaster item);
        
    }
}
