﻿#region Using Directives
using System;
using System.ServiceModel;
using PUMA.PcehrDataStore.Schemas;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using HIPS.CommonSchemas.PatientIdentifier;
using HIPS.CommonSchemas;
using HIPS.PcehrDataStore.Schemas; 
#endregion

namespace PUMA.ServiceContracts.ServiceInterface
{
    [ServiceContract(Namespace = "http://schemas.PUMA/Services/2012/01", Name = "PatientService")]
    public interface IPatientService
    {

        [OperationContract]
        bool Get(int patientID, bool includeFullDetails, out Patient patient, DateTime? lastUpdate = null);

        [OperationContract]
        List<PatientsMissingIhiReport> PatientsWithoutIhi(int? hospitalId);

        [OperationContract]
        List<PatientsWithOverridesReport> PatientsWithOverridesReport(int? hospitalId);

        [OperationContract]
        bool Update(Patient patient);

        /// <summary>
        /// Gets a list of patients with an IHI.
        /// </summary>
        /// <param name="hospitalId">The hospital id.</param>
        /// <returns></returns>
        [OperationContract]
        ObservableCollection<PatientTile> PatientsWithIhi(int? hospitalId);

        /// <summary>
        /// Records the disclosure of PCEHR.
        /// </summary>
        /// <param name="pcehrDisclosed">if set to <c>true</c> [pcehr disclosed].</param>
        /// <param name="patientIdentifier">The patient identifier.</param>
        /// <param name="user">The user.</param>
        /// <param name="auditInformation">The audit information.</param>
        /// <returns></returns>
        [OperationContract]
        bool RecordDisclosure(bool pcehrDisclosed, PatientIdentifierBase patientIdentifier, byte[] auditInformation);

        /// <summary>
        /// Gets the current disclosure reason.
        /// </summary>
        /// <param name="healthProviderOrganisationId">The health provider organisation id.</param>
        /// <param name="patientMasterId">The patient master id.</param>
        /// <returns></returns>
        [OperationContract]
        string GetCurrentDisclosureReason(int healthProviderOrganisationId, int patientMasterId);
    }
}
