﻿#region Using Directives
using System.ServiceModel;
using HIPS.PcehrDataStore.Schemas;
using System.Collections.Generic; 
#endregion

namespace PUMA.ServiceContracts.ServiceInterface
{
    [ServiceContract(Namespace = "http://schemas.PUMA/Services/2012/01", Name = "PcehrService")]
    public interface IPcehrService
    {
        /// <summary>
        /// Gets all clinical documents.
        /// </summary>
        /// <returns></returns>
        [OperationContract]
        List<ClinicalDocument> GetAll();

        /// <summary>
        /// Gets the specified clinical document for episode ID.
        /// </summary>
        /// <param name="episodeID">The episode ID.</param>
        /// <param name="isPatientKnown">if set to <c>true</c> [is patient known].</param>
        /// <returns></returns>
        [OperationContract]
        ClinicalDocument Get(int episodeID, bool isPatientKnown);

        /// <summary>
        /// Saves the specified clinical document.
        /// </summary>
        /// <param name="Pcehr">The clinical document.</param>
        /// <returns></returns>
        [OperationContract]
        bool Save(ref ClinicalDocument Pcehr);

        /// <summary>
        /// Determines whether [is database available].
        /// </summary>
        /// <returns>
        ///   <c>true</c> if [is database available]; otherwise, <c>false</c>.
        /// </returns>
        [OperationContract]
        bool IsDatabaseAvailable();

        /// <summary>
        /// Supersedes the specified clinical document.
        /// </summary>
        /// <param name="pcehr">The clinical document.</param>
        /// <returns></returns>
        [OperationContract]
        bool Supersede(ref ClinicalDocument pcehr);

    }
}
