﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Data.SqlClient;
using System.Configuration;
using System.Data;
using System.Reflection;
using System.Collections.ObjectModel;
using HIPS.Base.Schemas;

namespace Test.Helpers
{
    /// <summary>
    /// This helper class provides a data access layer used for the test projects
    /// </summary>
    static public class DataAccess
    {
        #region Properties
        static public SqlCommand TestSqlCommand
        {
            get
            {
                SqlCommand testCommand = new SqlCommand();
                testCommand.Connection = new SqlConnection(ConfigurationManager.ConnectionStrings["TestPcehrDataStoreConnectionString"].ToString());
                if (testCommand.Connection.State != System.Data.ConnectionState.Open)
                {
                    testCommand.Connection.Open();
                }
                return testCommand;
            }
        }
        #endregion
        #region Methods
        /// <summary>
        /// Valids that a business schema has been populated correctly.
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="dataTable">The data table.</param>
        /// <param name="populatedObject">The populated object.</param>
        /// <returns></returns>
        //TODO: Need to resolve this so that the data in the two results can be validated
        static public bool ValidSchemaPolulation<T>(DataTable dataTable, ObservableCollection<T> populatedObject)
        {
            bool result = true;
            Dictionary<string, int> columnOrdinals = new Dictionary<string, int>();

            for (int count = 0; count < dataTable.Columns.Count; count++)
            {
                string columnname = dataTable.Columns[count].ColumnName.ToUpper();
                if (!columnOrdinals.ContainsKey(columnname))
                {
                    columnOrdinals.Add(columnname, count);
                }
                else
                {
                    throw new Exception("Column name has been duplicated");
                }
            }

            PropertyInfo info = null;
            //TODO: Validate the number of columns that are supposed to be read in from the database
            PropertyInfo[] properties = populatedObject[0].GetType().GetProperties();
            int objectColumns = 0;
            foreach (PropertyInfo currentinfo in populatedObject[0].GetType().GetProperties())
            {
                object[] attributes = currentinfo.GetCustomAttributes(typeof(DataBaseInfoAttributes), false);
                if (attributes != null && attributes.Count() > 0)
                {
                    objectColumns++;
                }
            }
            if (columnOrdinals.Count != objectColumns)
            {
                throw new Exception("Invalid number of columns");
            }
            object businessValue = null;
            for (int count = 0; count < dataTable.Rows.Count; count++)
            {
                DataRow row = dataTable.Rows[count];
                T item = populatedObject[count];
                foreach (KeyValuePair<string, int> column in columnOrdinals)
                {
                    bool found = false;
                    for (int i = 0; i < properties.Length; i++)
                    {
                        if (string.Compare(properties[i].Name, column.Key, StringComparison.OrdinalIgnoreCase) == 0)
                        {
                            info = properties[i];
                            businessValue = info.GetValue(populatedObject[count], null);
                            found = true;
                            break;
                        }
                    }
                    if (!found)
                    {
                        throw new Exception(string.Format("Column {0} is missing",column.Key));
                    }
                   
                    if (row.IsNull(column.Value) && businessValue == null)
                    {
                        continue;
                    }
                    object tableValue = row[column.Value];
                    if (!tableValue.Equals(businessValue))
                    {
                        throw new Exception("Date does not match");
                    }
                }
            }

            //foreach (KeyValuePair<string, int> column in columnOrdinals)
            //{
            //    // Find a Property with the same name as the Column
            //    info = null;
            //    for (int i = 0; i < properties.Length; i++)
            //    {
            //        if (string.Compare(properties[i].Name, column.Key, StringComparison.OrdinalIgnoreCase) == 0)
            //        {
            //            info = properties[i];
            //            break;
            //        }
            //    }
            //}
            return result;
        }
        #endregion
    }
}
